/*
 * QMenu_tooltip.hpp
 *
 *  Created on: Sep 8, 2014
 *      Author: heber
 */

#ifndef QMENU_TOOLTIP_HPP_
#define QMENU_TOOLTIP_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QEvent>
#include <QHelpEvent>
#include <QMenu>
#include <QToolTip>
#include <iostream>

/** Derived from QMenu to override default behavior of not showing tooltip event.
 *
 * This was taken from http://qt-project.org/faq/answer/how_can_i_add_tooltips_to_actions_in_menus
 * in order to show tooltips for the Actions.
 */
class QMenu_tooltip : public QMenu
{
  Q_OBJECT
public:
  QMenu_tooltip(const QString &_title) :
    QMenu(_title)
  {}
  bool event (QEvent * e)
  {
    if (e->type() == QEvent::ToolTip) {
      const QHelpEvent *helpEvent = static_cast <QHelpEvent *>(e);
      // call QToolTip::showText on that QAction's tooltip.
      QToolTip::showText(helpEvent->globalPos(), activeAction()->toolTip());
    } else {
      QToolTip::hideText();
    }
    return QMenu::event(e);
  }
};


#endif /* QMENU_TOOLTIP_HPP_ */
