/*
 * ShapeRegistry.hpp
 *
 *  Created on: Sep 13, 2012
 *      Author: ankele
 */

#ifndef SHAPEREGISTRY_HPP_
#define SHAPEREGISTRY_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>

#include "CodePatterns/Observer/Observable.hpp"
#include "CodePatterns/Registry.hpp"
#include "CodePatterns/Singleton.hpp"

#include "Shape.hpp"

class ShapeRegistry : public Singleton<ShapeRegistry>, public Registry<Shape>, public Observable
{
  friend class Singleton<ShapeRegistry>;

public:
  void addShape(Shape s);
  void removeShape(const std::string &name);
  //Shape* getShapeByName(const std::string name);
  //bool isShapePresentByName(const std::string name) const;
  std::string getDefaultNameForShape(Shape s) const;

  enum NotificationType {
    ShapeInserted,
    ShapeRemoved,
    SelectionChanged,
    NotificationType_MAX
  };

  void selectShape(const std::string &name);
  void selectShape(Shape *s);
  void unselectShape(const std::string &name);
  void unselectShape(Shape *s);
  void selectAllShapes();
  void unselectAllShapes();
  void invertShapeSelection();
  bool isSelected(const std::string &name) const;
  bool isSelected(Shape *s) const;
  int countSelectedShapes() const;
  std::vector<Shape*> getSelectedShapes() const;

  Shape *lastChanged() const { return _lastchanged;  }

private:
  // private constructor and destructor due to singleton
  ShapeRegistry();
  virtual ~ShapeRegistry();

  std::map<std::string, Shape*> selectedShapes;
  Shape *_lastchanged;
};

#endif /* SHAPEREGISTRY_HPP_ */
