/*
 * Dialog.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include "Dialog.hpp"

#include "atom.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "vector.hpp"
#include "Matrix.hpp"
#include "Box.hpp"

using namespace std;

Dialog::Dialog()
{
}

Dialog::~Dialog()
{
  list<Query*>::iterator iter;
  for(iter=queries.begin();iter!=queries.end();iter++){
    delete (*iter);
  }
}

void Dialog::registerQuery(Query *query){
  queries.push_back(query);
}

bool Dialog::display(){
  list<Query*>::iterator iter;
  bool retval = true;
  for(iter=queries.begin(); iter!=queries.end(); iter++){
    retval &= (*iter)->handle();
    // if any query fails (is canceled), we can end the handling process
    if(!retval) {
      DoeLog(1) && (eLog() << Verbose(1) << "The following query failed: " << (**iter).getTitle() << "." << endl);
      break;
    }
  }
  if (retval){
    // if all queries succeeded we can set the targets to appropriate values
    for(iter=queries.begin(); iter!=queries.end(); iter++) {
      (*iter)->setResult();
    }
  }
  return retval;
}

/****************** Query types Infrastructure **************************/

// Base class
Dialog::Query::Query(string _title, string _description) :
    title(_title),
    description(_description)
{}

Dialog::Query::~Query() {}

const std::string Dialog::Query::getTitle() const{
  return title;
}

const std::string Dialog::Query::getDescription() const{
  return description;
}
// empty Queries

Dialog::EmptyQuery::EmptyQuery(string title, std::string description) :
    Query(title, description)
{}

Dialog::EmptyQuery::~EmptyQuery() {}

void Dialog::EmptyQuery::setResult() {
}

// Int Queries

Dialog::IntQuery::IntQuery(string title,int *_target, std::string description) :
    Query(title, description), target(_target)
{}

Dialog::IntQuery::~IntQuery() {}

void Dialog::IntQuery::setResult() {
  *target = tmp;
}

// Int Queries

Dialog::BooleanQuery::BooleanQuery(string title,bool *_target, std::string description) :
    Query(title, description), target(_target)
{}

Dialog::BooleanQuery::~BooleanQuery() {}

void Dialog::BooleanQuery::setResult() {
  *target = tmp;
}

// String Queries

Dialog::StringQuery::StringQuery(string title,string *_target, std::string _description) :
    Query(title, _description), target(_target)
{}

Dialog::StringQuery::~StringQuery() {};

void Dialog::StringQuery::setResult() {
  *target = tmp;
}

// Double Queries

Dialog::DoubleQuery::DoubleQuery(string title,double *_target, std::string _description) :
    Query(title, _description), target(_target)
{}

Dialog::DoubleQuery::~DoubleQuery() {};

void Dialog::DoubleQuery::setResult() {
  *target = tmp;
}


// Atom Queries

Dialog::AtomQuery::AtomQuery(string title, atom **_target, std::string _description) :
    Query(title, _description),
    tmp(0),
    target(_target)

{}

Dialog::AtomQuery::~AtomQuery() {}

void Dialog::AtomQuery::setResult() {
  *target = tmp;
}

// Molecule Queries

Dialog::MoleculeQuery::MoleculeQuery(string title, molecule **_target, std::string _description) :
    Query(title, _description),
    tmp(0),
    target(_target)

{}

Dialog::MoleculeQuery::~MoleculeQuery() {}

void Dialog::MoleculeQuery::setResult() {
  *target = tmp;
}

// Vector Queries

Dialog::VectorQuery::VectorQuery(std::string title,Vector *_target,bool _check, std::string _description) :
  Query(title, _description),
  check(_check),
  target(_target)
{
  tmp = new Vector();
}

Dialog::VectorQuery::~VectorQuery()
{
  delete tmp;
}

void Dialog::VectorQuery::setResult() {
  *target = *tmp;
}

// Box Queries

Dialog::BoxQuery::BoxQuery(std::string title, Box* _cellSize, std::string _description) :
  Query(title, _description),
  target(_cellSize)
{
    tmp = new double[6];
}

Dialog::BoxQuery::~BoxQuery()
{
  delete[] tmp;
}

void Dialog::BoxQuery::setResult() {
  (*target)= ReturnFullMatrixforSymmetric(tmp);
}

// Element Queries
Dialog::ElementQuery::ElementQuery(std::string title, std::vector<element *> *_target, std::string _description) :
  Query(title, _description),
  target(_target)
  {}

Dialog::ElementQuery::~ElementQuery(){}

void Dialog::ElementQuery::setResult(){
  *target=elements;
}
