/*
 * CommandLineDialog.hpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#ifndef COMMANDLINEDIALOG_HPP_
#define COMMANDLINEDIALOG_HPP_

#include <string>

class atom;
class element;
class molecule;
class Vector;

#include "Dialog.hpp"

/** CommandLineUIFactory implementation of the Dialog.
 * The idea here is that for each query the parsed command line options are used instead.
 */
class CommandLineDialog : public Dialog
{
public:
  CommandLineDialog();
  virtual ~CommandLineDialog();

  virtual void queryEmpty(const char *, std::string = "");
  virtual void queryInt(const char *, int *, std::string = "");
  virtual void queryBoolean(const char *, bool *, std::string = "");
  virtual void queryString(const char*, std::string *, std::string = "");
  virtual void queryDouble(const char*, double*, std::string = "");
  virtual void queryAtom(const char*,atom**, std::string = "");
  virtual void queryMolecule(const char*,molecule**,std::string = "");
  virtual void queryVector(const char*,Vector *,bool, std::string = "");
  virtual void queryBox(const char*,Box *, std::string = "");
  virtual void queryElement(const char*, std::vector<element *> *, std::string = "");

protected:
  // specialized stuff for text queries
  class EmptyCommandLineQuery : public Dialog::EmptyQuery {
  public:
    EmptyCommandLineQuery(std::string title, std::string _description = "");
    virtual ~EmptyCommandLineQuery();
    virtual bool handle();
  };

  class IntCommandLineQuery : public Dialog::IntQuery {
  public:
    IntCommandLineQuery(std::string title, int *_target, std::string _description = "");
    virtual ~IntCommandLineQuery();
    virtual bool handle();
  };

  class BooleanCommandLineQuery : public Dialog::BooleanQuery {
  public:
    BooleanCommandLineQuery(std::string title, bool *_target, std::string _description = "");
    virtual ~BooleanCommandLineQuery();
    virtual bool handle();
  };

  class DoubleCommandLineQuery : public Dialog::DoubleQuery {
  public:
    DoubleCommandLineQuery(std::string title, double *_target, std::string _description = "");
    virtual ~DoubleCommandLineQuery();
    virtual bool handle();
  };

  class StringCommandLineQuery : public Dialog::StringQuery {
  public:
    StringCommandLineQuery(std::string title, std::string *_target, std::string _description = "");
    virtual ~StringCommandLineQuery();
    virtual bool handle();
  };

  class AtomCommandLineQuery : public Dialog::AtomQuery {
  public:
    AtomCommandLineQuery(std::string title, atom **_target, std::string _description = "");
    virtual ~AtomCommandLineQuery();
    virtual bool handle();
  };

  class MoleculeCommandLineQuery : public Dialog::MoleculeQuery {
  public:
    MoleculeCommandLineQuery(std::string title, molecule **_target, std::string _description = "");
    virtual ~MoleculeCommandLineQuery();
    virtual bool handle();
  };

  class VectorCommandLineQuery : public Dialog::VectorQuery {
  public:
    VectorCommandLineQuery(std::string title,Vector *_target,bool _check, std::string _description = "");
    virtual ~VectorCommandLineQuery();
    virtual bool handle();
  };

  class BoxCommandLineQuery : public Dialog::BoxQuery {
  public:
    BoxCommandLineQuery(std::string title,Box* _cellSize, std::string _description = "");
    virtual ~BoxCommandLineQuery();
    virtual bool handle();
  };

  class ElementCommandLineQuery : public Dialog::ElementQuery {
  public:
    ElementCommandLineQuery(std::string title, std::vector<element *> *_target, std::string _description = "");
    virtual ~ElementCommandLineQuery();
    virtual bool handle();
  };
};

#endif /* COMMANDLINEDIALOG_HPP_ */
