/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BoxLengthValidatorStub.cpp
 *
 *  Created on: Jun 6, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Parameters/Validators/Specific/BoxLengthValidator.hpp"

bool BoxLengthValidator::isValid(const double & _value) const
{
  return true;
}

bool BoxLengthValidator::operator==(const Validator<double> &_instance) const
{
  const BoxLengthValidator *inst =
      dynamic_cast<const BoxLengthValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< double >* BoxLengthValidator::clone() const
{
  Validator< double > *inst =
      new BoxLengthValidator();
  return inst;
}
