/*
 * FilePresentValidator.hpp
 *
 *  Created on: May 9, 2012
 *      Author: heber
 */

#ifndef FILEPRESENTVALIDATOR_HPP_
#define FILEPRESENTVALIDATOR_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Parameters/Validators/DummyValidator.hpp"

#include <boost/filesystem.hpp>

class FilePresentValidator : public Validator< boost::filesystem::path >
{
  bool isValid(const boost::filesystem::path & _value) const
  {
    return boost::filesystem::exists(_value);
  }
  bool operator==(const Validator<boost::filesystem::path> &_instance) const
  {
    const FilePresentValidator *inst =
        dynamic_cast<const FilePresentValidator *>(&_instance);
    if (inst)
      return true;
    else
      return false;
  }

  Validator< boost::filesystem::path >* clone() const
  {
    Validator< boost::filesystem::path > *inst =
        new FilePresentValidator();
    return inst;
  }
};


#endif /* FILEPRESENTVALIDATOR_HPP_ */
