/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BoxLengthValidator.cpp
 *
 *  Created on: May 9, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "BoxLengthValidator.hpp"

#include "LinearAlgebra/RealSpaceMatrix.hpp"

#include "Box.hpp"
#include "World.hpp"

bool BoxLengthValidator::isValid(const double & _value) const
{
  const RealSpaceMatrix &M = World::getInstance().getDomain().getM();
  bool status = true;
  for (size_t i=0;i<NDIM;++i)
    status = status && (_value >=0) && (M.column(i).NormSquared() > _value);
  return status;
}

bool BoxLengthValidator::operator==(const Validator<double> &_instance) const
{
  const BoxLengthValidator *inst =
      dynamic_cast<const BoxLengthValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< double >* BoxLengthValidator::clone() const
{
  Validator< double > *inst =
      new BoxLengthValidator();
  return inst;
}
