/*
 * Assert.cpp
 *
 *  Created on: Mar 18, 2010
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include "Helpers/Assert.hpp"
#include <iostream>

using namespace std;

namespace Assert{
  AssertionFailure::AssertionFailure(std::string _condition,
                                     std::string _file,
                                     int _line,
                                     std::string _message) :
    condition(_condition),
    file(_file),
    line(_line),
    message(_message)
  {}

  std::string AssertionFailure::getFile(){
    return file;
  }

  int AssertionFailure::getLine(){
    return line;
  }

  std::string AssertionFailure::getMessage(){
    return message;
  }

  std::ostream& AssertionFailure::operator<<(std::ostream& out){
    out << "Assertion \"" << condition << "\" failed in file " << file << " at line " << line << endl;
    out << "Assertion Message: " << message << std::endl;
    return out;
  }

  const char  ActionKeys[]  = {'\0','a','t','i'};
  const char* ActionNames[] = {"Ask","Abort","Throw","Ignore"};
}

#ifndef NDEBUG

Assert::Action Assert::_my_assert::defaultAction = Ask;
std::vector<Assert::hook_t> Assert::_my_assert::hooks;

std::map<std::string,bool> Assert::_wrapper::ignores;
const char* Assert::_wrapper::message_ptr = "source pointer did not point to object of desired type";
const char* Assert::_wrapper::message_ref = "source reference did not contain object of desired type";


bool Assert::_my_assert::check(const bool res,
                       const char* condition,
                       const char* message,
                       const char* filename,
                       const int line,
                       bool& ignore)
{
  if(!res){
    cout << "Assertion \"" << condition << "\" failed in file " << filename << " at line " << line << endl;
    cout << "Assertion Message: " << message << std::endl;
    while(true){
      char choice;
      if(defaultAction==Assert::Ask) {
        cout << "Please choose: (a)bort, (t)hrow execption, (i)gnore, al(w)ays ignore" << endl;
        cin >> choice;
      }
      else{
        choice = ActionKeys[defaultAction];
      }
      switch(choice){
        case 'a':
          return true;
          break;
        case 't':
          throw AssertionFailure(condition,filename,line,message);
          break;
        case 'w':
          ignore = true;
          // fallthrough
        case 'i':
          return false;
          break;
      }
    }
  }
  return false;
}

void Assert::_my_assert::doHooks(){
  for(vector<hook_t>::reverse_iterator iter = hooks.rbegin(); iter!=hooks.rend(); ++iter ){
    (*iter)();
  }
}

void Assert::_my_assert::addHook(hook_t hook){
  hooks.push_back(hook);
}

void Assert::_my_assert::removeHook(Assert::hook_t hook){
  for(vector<hook_t>::iterator iter = hooks.begin(); iter!=hooks.end();){
    if((*iter)==hook){
      iter = hooks.erase(iter);
    }
    else{
      ++iter;
    }
  }
}

void Assert::_my_assert::setDefault(Assert::Action action){
  defaultAction = action;
}
Assert::Action Assert::_my_assert::getDefault(){
  return defaultAction;
}
std::string Assert::_my_assert::printDefault(){
  return ActionNames[defaultAction];
}

#endif

