/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * CommandLineDialog.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/CommandLineDialog.hpp"
#include "CommandLineUI/Query/CommandLineQuery.hpp"


using namespace std;


CommandLineDialog::CommandLineDialog(const std::string &_title) :
    Dialog(_title)
{
}

CommandLineDialog::~CommandLineDialog()
{
}


void CommandLineDialog::queryEmpty(const std::string title, const std::string description){
  registerQuery(new EmptyCommandLineQuery(title, description));
}

void CommandLineDialog::queryInt(Parameter<int> &param, const std::string title, const std::string description){
  registerQuery(new IntCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryInts(Parameter<std::vector<int> > &param, const std::string title, const std::string description){
  registerQuery(new IntsCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryUnsignedInt(Parameter<unsigned int> &param, const std::string title, const std::string description){
  registerQuery(new UnsignedIntCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryUnsignedInts(Parameter<std::vector<unsigned int> > &param, const std::string title, const std::string description){
  registerQuery(new UnsignedIntsCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryBoolean(Parameter<bool> &param, const std::string title, const std::string description){
  registerQuery(new BooleanCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryDouble(Parameter<double> &param, const std::string title, const std::string description){
  registerQuery(new DoubleCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryDoubles(Parameter<std::vector<double> > &param, const std::string title, const std::string description){
  registerQuery(new DoublesCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryString(Parameter<std::string> &param, const std::string title, const std::string description){
  registerQuery(new StringCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryStrings(Parameter<std::vector<std::string> > &param, const std::string title, const std::string description){
  registerQuery(new StringsCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryAtom(Parameter<const atom *> &param, const std::string title, const std::string description) {
  registerQuery(new AtomCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryAtoms(Parameter<std::vector<const atom *> > &param, const std::string title, const std::string description) {
  registerQuery(new AtomsCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryMolecule(Parameter<const molecule *> &param, const std::string title, const std::string description) {
  registerQuery(new MoleculeCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryMolecules(Parameter<std::vector<const molecule *> > &param, const std::string title, const std::string description) {
  registerQuery(new MoleculesCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryVector(Parameter<Vector> &param, const std::string title, const std::string description) {
  registerQuery(new VectorCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryVectors(Parameter<std::vector<Vector> > &param, const std::string title, const std::string description) {
  registerQuery(new VectorsCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryRealSpaceMatrix(Parameter<RealSpaceMatrix> &param, const std::string title, const std::string description) {
  registerQuery(new RealSpaceMatrixCommandLineQuery(param, title,description));
}

void CommandLineDialog::queryElement(Parameter<const element *> &param, const std::string title, const std::string description){
  registerQuery(new ElementCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryElements(Parameter<std::vector<const element *> > &param, const std::string title, const std::string description){
  registerQuery(new ElementsCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryFile(Parameter<boost::filesystem::path> &param, const std::string title, const std::string description){
  registerQuery(new FileCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryFiles(Parameter<std::vector< boost::filesystem::path> > &param, const std::string title, const std::string description){
  registerQuery(new FilesCommandLineQuery(param, title, description));
}

void CommandLineDialog::queryRandomNumberDistribution_Parameters(Parameter<RandomNumberDistribution_Parameters> &param, const std::string title, const std::string description){
  registerQuery(new RandomNumberDistribution_ParametersCommandLineQuery(param, title, description));
}

/************************** Query Infrastructure ************************/
/*       ---> shifted to folder Query                                   */
/************************************************************************/
