/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorsQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui/QDoubleSpinBox>
#include <Qt/qboxlayout.h>
#include <Qt/qcombobox.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/VectorsQtQueryPipe.hpp"


QtDialog::VectorsQtQuery::VectorsQtQuery(Parameter<std::vector<Vector> > &_param, std::string title, QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::VectorsQuery(_param, title),
    parent(_parent),
    dialog(_dialog)
{
  mainLayout= new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  mainLayout->addWidget(titleLabel);
  subLayout = new QVBoxLayout();
  mainLayout->addLayout(subLayout);
  QComboBox* inputBox = new QComboBox();
  coordLayout = new QHBoxLayout();
  subLayout->addLayout(coordLayout);
  coordLabel = new QLabel(QString("x,y,z"));
  coordLayout->addWidget(coordLabel);
  coordInput = new QDoubleSpinBox();
//  coordInput->setRange(0,M.at(i,i));
  coordInput->setDecimals(3);
  coordLayout->addWidget(coordInput);
  /*pipe = new VectorsQtQueryPipe(temp,_dialog,inputBox);
  //pipe->update(coordInput->value());
  connect(coordInput,SIGNAL(valueChanged(double)),pipe,SLOT(update(double)));*/
  parent->addLayout(mainLayout);
}

QtDialog::VectorsQtQuery::~VectorsQtQuery()
{}

void QtDialog::VectorsQtQuery::onUpdate() {
  dialog->update();
}

bool QtDialog::VectorsQtQuery::handle() {
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}


