/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * UnsignedIntsQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>
#include <Qt/qlineedit.h>
#include <Qt/qlistwidget.h>
#include <Qt/qpushbutton.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/QtQueryListPipe.hpp"


QtDialog::UnsignedIntsQtQuery::UnsignedIntsQtQuery(Parameter<std::vector<unsigned int> > &_param, std::string _title,QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::UnsignedIntsQuery(_param, _title),
    parent(_parent),
    dialog(_dialog)
{
  QHBoxLayout * thisHLayout = new QHBoxLayout();
  QVBoxLayout * thisV1Layout = new QVBoxLayout();
  QVBoxLayout * thisV2Layout = new QVBoxLayout();

  QLabel *titleLabel = new QLabel(QString(getTitle().c_str()));
  QLabel *inputLabel = new QLabel("Enter to add");
  QListWidget* inputList = new QListWidget();
  inputList->setSelectionMode(QAbstractItemView::ExtendedSelection);
  QLineEdit* inputBox = new QLineEdit();
  inputLabel->setBuddy(inputBox);
  titleLabel->setBuddy(inputList);
  QPushButton* AddButton = new QPushButton("Add");
  AddButton->setEnabled(false);
  QPushButton* RemoveButton = new QPushButton("Remove");
  RemoveButton->setEnabled(false);

  thisV1Layout->addWidget(titleLabel);
  thisV1Layout->addWidget(inputList);
  thisV2Layout->addWidget(inputLabel);
  thisV2Layout->addWidget(inputBox);
  thisV2Layout->addWidget(AddButton);
  thisV2Layout->addWidget(RemoveButton);
  parent->addLayout(thisHLayout);
  thisHLayout->addLayout(thisV1Layout);
  thisHLayout->addLayout(thisV2Layout);

  /*pipe = new QtQueryListPipe<unsigned int>(temp,_dialog,inputBox,inputList,AddButton,RemoveButton);
  connect(inputBox,SIGNAL(textChanged(const QString&)),pipe,SLOT(IntegerEntered(const QString&)));
  connect(inputList,SIGNAL(itemSelectionChanged()),pipe,SLOT(IntegerSelected()));
  connect(AddButton,SIGNAL(Clicked()),pipe,SLOT(AddValue()));
  connect(RemoveButton,SIGNAL(Clicked()),pipe,SLOT(RemoveRow()));*/
}

QtDialog::UnsignedIntsQtQuery::~UnsignedIntsQtQuery()
{
}

void QtDialog::UnsignedIntsQtQuery::onUpdate() {
  dialog->update();
}

bool QtDialog::UnsignedIntsQtQuery::handle() {
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}


