/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RandomNumberDistribution_ParametersQtQuery.cpp
 *
 *  Created on: Jan 06, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qpushbutton.h>
#include <Qt/qtextedit.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/RandomNumberDistribution_ParametersQtQueryPipe.hpp"

#include "Atom/atom.hpp"
#include "World.hpp"

QtDialog::RandomNumberDistribution_ParametersQtQuery::RandomNumberDistribution_ParametersQtQuery(Parameter<RandomNumberDistribution_Parameters> &_param, std::string _title,QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::RandomNumberDistribution_ParametersQuery(_param, _title),
    parent(_parent),
    dialog(_dialog)
{
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));

//  inputBox->insertItem(-1, QString("no distribution"));
//  for (std::vector<distribution *>::const_iterator iter = distribution(); iter != distribution.end(); ++iter)
//    inputBox->insertItem((*iter)->getNr(),QString::fromStdString((*iter)->getName()));

  inputBox = new QTextEdit();

  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  okButton = new QPushButton(tr("Ok"));

  connect(okButton,SIGNAL(clicked()),this,SLOT(onUpdate()));
}

QtDialog::RandomNumberDistribution_ParametersQtQuery::~RandomNumberDistribution_ParametersQtQuery()
{
}

void QtDialog::RandomNumberDistribution_ParametersQtQuery::onUpdate() {
  QString data = inputBox->toPlainText();
  std::stringstream text(data.toStdString());
  // TODO: check error
  //text >> temp;
  dialog->update();
}

bool QtDialog::RandomNumberDistribution_ParametersQtQuery::handle() {
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}


