/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * IntQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>
#include <Qt/qspinbox.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/IntQtQueryPipe.hpp"


QtDialog::IntQtQuery::IntQtQuery(Parameter<int> &_param, std::string _title,QBoxLayout *_parent,Dialog *_dialog) :
    Dialog::IntQuery(_param, _title),
    parent(_parent),
    dialog(_dialog)
{
  temp = 0;
  if (param.isSet())
    temp = param.get();
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputBox = new QSpinBox();
  inputBox->setValue(temp);
  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  connect(inputBox,SIGNAL(valueChanged(int)),this,SLOT(onUpdate(int)));
}

QtDialog::IntQtQuery::~IntQtQuery()
{
}

void QtDialog::IntQtQuery::onUpdate(int newInt) {
  temp = newInt;
  dialog->update();
}

bool QtDialog::IntQtQuery::handle() {
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}

