/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FileQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>
#include <Qt/qlineedit.h>
#include <Qt/qpushbutton.h>
#include <QtGui/QFileDialog>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/FileQtQueryPipe.hpp"


QtDialog::FileQtQuery::FileQtQuery(Parameter<boost::filesystem::path> &_param, std::string _title, QBoxLayout *_parent, Dialog *_dialog) :
    Dialog::FileQuery(_param, _title),
    parent(_parent),
    dialog(_dialog)
{

  filenameLineEdit = new QLineEdit();
  filenameLineEdit->setText(QString());
  filenameLineEdit->setReadOnly(true);

  filenameLabel = new QLabel(QString("Input file:"));
  filenameLabel->setBuddy(filenameLineEdit);

  filedialogButton = new QPushButton("&Choose");
  theFileDialog = NULL;

  thisLayout = new QHBoxLayout();
  parent->addLayout(thisLayout);
  thisLayout->addWidget(filenameLabel);
  thisLayout->addWidget(filenameLineEdit);
  thisLayout->addWidget(filedialogButton);

  QObject::connect(filedialogButton,SIGNAL(clicked()),this,SLOT(showFileDialog()));
}

QtDialog::FileQtQuery::~FileQtQuery()
{
  if (theFileDialog != NULL)
    delete theFileDialog;
}

void QtDialog::FileQtQuery::onUpdate() {
  QStringList ListOfFilenames = theFileDialog->selectedFiles();
  std::cout << "Selected File is " << ListOfFilenames.at(0).toStdString() << std::endl;
  temp = ListOfFilenames.at(0).toStdString();
  filenameLineEdit->setText(QString::fromStdString(temp.string()));
  dialog->update();
}

void QtDialog::FileQtQuery::showFileDialog() {
  filedialogButton->setFlat(true);
  if (theFileDialog == NULL) {
    theFileDialog = new QFileDialog(NULL, tr("Open input file"), QString(), tr("ParallelCarParrinello (*.conf);;MassivelyParallelQuantumChemistry (*.mpqc);;ParticleDataBase (*.pdb);;XYZ (*.xyz)"));
    theFileDialog->setAcceptMode(QFileDialog::AcceptOpen);
    theFileDialog->setFileMode(QFileDialog::AnyFile);
    theFileDialog->setViewMode(QFileDialog::List);
  }
  theFileDialog->exec();

  onUpdate();
  filedialogButton->setFlat(false);
}

bool QtDialog::FileQtQuery::handle(){
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}

