/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * EmptyQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/EmptyQtQueryPipe.hpp"


QtDialog::EmptyQtQuery::EmptyQtQuery(std::string _title, QBoxLayout *_parent, Dialog *_dialog) :
    Dialog::EmptyQuery(_title),
    parent(_parent),
    dialog(_dialog)
{
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));

  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
}

QtDialog::EmptyQtQuery::~EmptyQtQuery()
{
}

bool QtDialog::EmptyQtQuery::handle(){
  return true;
}


