/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementsQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qcombobox.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/ElementsQtQueryPipe.hpp"

#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "World.hpp"


QtDialog::ElementsQtQuery::ElementsQtQuery(Parameter<std::vector<const element *> > &_param, std::string _title, QBoxLayout *_parent, Dialog *_dialog) :
    Dialog::ElementsQuery(_param, _title),
    parent(_parent),
    dialog(_dialog)
{
  periodentafel *periode = World::getInstance().getPeriode();
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputBox = new QComboBox();
  for(periodentafel::const_iterator iter = periode->begin();
      iter!=periode->end();
      ++iter)
  {
    std::stringstream sstr;
    sstr << (*iter).first << "\t" << (*iter).second->getName();
    inputBox->addItem(QString(sstr.str().c_str()),QVariant((*iter).first));
  }
  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  /*pipe = new ElementsQtQueryPipe(temp,_dialog,inputBox);
  pipe->update(inputBox->currentIndex());
  connect(inputBox,SIGNAL(currentIndexChanged(int)),pipe,SLOT(update(int)));*/
}

QtDialog::ElementsQtQuery::~ElementsQtQuery()
{
}

void QtDialog::ElementsQtQuery::onUpdate() {
  dialog->update();
}

bool QtDialog::ElementsQtQuery::handle(){
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}

