/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BooleanQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qcheckbox.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/BooleanQtQueryPipe.hpp"


QtDialog::BooleanQtQuery::BooleanQtQuery(Parameter<bool> &_param, std::string _title, QBoxLayout *_parent, Dialog *_dialog) :
    Dialog::BooleanQuery(_param, _title),
    parent(_parent),
    dialog(_dialog)
{
  temp = false;
  if (param.isSet())
    temp = param.get();
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  booleanCheckBox = new QCheckBox(QString(getTitle().c_str()));
  booleanCheckBox->setCheckState(temp ? Qt::Checked : Qt::Unchecked);

  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(booleanCheckBox);

  connect(booleanCheckBox, SIGNAL(stateChanged(int)), this, SLOT(onUpdate(int)));
}

QtDialog::BooleanQtQuery::~BooleanQtQuery()
{
}

void QtDialog::BooleanQtQuery::onUpdate(int state) {
  temp = (state == Qt::Checked);
  dialog->update();
}

bool QtDialog::BooleanQtQuery::handle(){
  if (param.isValid(temp)){
    param.set(temp);
    return true;
  }
  return false;
}


