/*
 * Dialog.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include "Dialog.hpp"
#include "ValueStorage.hpp"

#include "verbose.hpp"
#include "atom.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "vector.hpp"
#include "Matrix.hpp"
#include "Box.hpp"

using namespace std;

Dialog::Dialog()
{
}

Dialog::~Dialog()
{
  list<Query*>::iterator iter;
  for(iter=queries.begin();iter!=queries.end();iter++){
    delete (*iter);
  }
}

void Dialog::registerQuery(Query *query){
  queries.push_back(query);
}

bool Dialog::display(){
  if(checkAll()){
    setAll();
    return true;
  }
  else{
    return false;
  }
}

bool Dialog::checkAll(){
  list<Query*>::iterator iter;
  bool retval = true;
  for(iter=queries.begin(); iter!=queries.end(); iter++){
    retval &= (*iter)->handle();
    // if any query fails (is canceled), we can end the handling process
    if(!retval) {
      DoeLog(1) && (eLog() << Verbose(1) << "The following query failed: " << (**iter).getTitle() << "." << endl);
      break;
    }
  }
  return retval;
}

void Dialog::setAll(){
  list<Query*>::iterator iter;
  for(iter=queries.begin(); iter!=queries.end(); iter++) {
    (*iter)->setResult();
  }
}

/****************** Query types Infrastructure **************************/

// Base class
Dialog::Query::Query(string _title, string _description) :
    title(_title),
    description(_description)
{}

Dialog::Query::~Query() {}

const std::string Dialog::Query::getTitle() const{
  return title;
}

const std::string Dialog::Query::getDescription() const{
  return description;
}
// empty Queries

Dialog::EmptyQuery::EmptyQuery(string title, std::string description) :
    Query(title, description)
{}

Dialog::EmptyQuery::~EmptyQuery() {}

void Dialog::EmptyQuery::setResult() {
}

// Int Queries

Dialog::IntQuery::IntQuery(string title, std::string description) :
    Query(title, description)
{}

Dialog::IntQuery::~IntQuery() {}

void Dialog::IntQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Ints Queries

Dialog::IntsQuery::IntsQuery(string title, std::string description) :
    Query(title, description)
{}

Dialog::IntsQuery::~IntsQuery() {}

void Dialog::IntsQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Bool Queries

Dialog::BooleanQuery::BooleanQuery(string title,std::string description) :
    Query(title, description)
{}

Dialog::BooleanQuery::~BooleanQuery() {}

void Dialog::BooleanQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// String Queries

Dialog::StringQuery::StringQuery(string title,std::string _description) :
    Query(title, _description)
{}

Dialog::StringQuery::~StringQuery() {};

void Dialog::StringQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Strings Queries

Dialog::StringsQuery::StringsQuery(string title,std::string _description) :
    Query(title, _description)
{}

Dialog::StringsQuery::~StringsQuery() {};

void Dialog::StringsQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Double Queries

Dialog::DoubleQuery::DoubleQuery(string title, std::string _description) :
    Query(title, _description)
{}

Dialog::DoubleQuery::~DoubleQuery() {};

void Dialog::DoubleQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Doubles Queries

Dialog::DoublesQuery::DoublesQuery(string title, std::string _description) :
    Query(title, _description)
{}

Dialog::DoublesQuery::~DoublesQuery() {};

void Dialog::DoublesQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}


// Atom Queries

Dialog::AtomQuery::AtomQuery(string title, std::string _description) :
    Query(title, _description),
    tmp(0)
{}

Dialog::AtomQuery::~AtomQuery() {}

void Dialog::AtomQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Atoms Queries

Dialog::AtomsQuery::AtomsQuery(string title, std::string _description) :
    Query(title, _description),
    tmp(0)
{}

Dialog::AtomsQuery::~AtomsQuery() {}

void Dialog::AtomsQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Molecule Queries

Dialog::MoleculeQuery::MoleculeQuery(string title, std::string _description) :
    Query(title, _description),
    tmp(0)
{}

Dialog::MoleculeQuery::~MoleculeQuery() {}

void Dialog::MoleculeQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Molecules Queries

Dialog::MoleculesQuery::MoleculesQuery(string title, std::string _description) :
    Query(title, _description),
    tmp(0)
{}

Dialog::MoleculesQuery::~MoleculesQuery() {}

void Dialog::MoleculesQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Vector Queries

Dialog::VectorQuery::VectorQuery(std::string title,bool _check, std::string _description) :
  Query(title, _description),
  check(_check)
{}

Dialog::VectorQuery::~VectorQuery()
{}

void Dialog::VectorQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Vectors Queries

Dialog::VectorsQuery::VectorsQuery(std::string title,bool _check, std::string _description) :
  Query(title, _description),
  check(_check)
{}

Dialog::VectorsQuery::~VectorsQuery()
{}

void Dialog::VectorsQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Box Queries

Dialog::BoxQuery::BoxQuery(std::string title, std::string _description) :
  Query(title, _description)
{
    tmp = new double[6];
}

Dialog::BoxQuery::~BoxQuery()
{
  delete[] tmp;
}

void Dialog::BoxQuery::setResult() {
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Element Queries
Dialog::ElementQuery::ElementQuery(std::string title, std::string _description) :
  Query(title, _description)
  {}

Dialog::ElementQuery::~ElementQuery(){}

void Dialog::ElementQuery::setResult(){
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}

// Elements Queries
Dialog::ElementsQuery::ElementsQuery(std::string title, std::string _description) :
  Query(title, _description)
  {}

Dialog::ElementsQuery::~ElementsQuery(){}

void Dialog::ElementsQuery::setResult(){
  ValueStorage::getInstance().setCurrentValue(title.c_str(), tmp);
}
