/*
 * CommandLineDialog.hpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#ifndef COMMANDLINEDIALOG_HPP_
#define COMMANDLINEDIALOG_HPP_

#include <string>

class atom;
class element;
class molecule;
class Vector;

#include "Dialog.hpp"

/** CommandLineUIFactory implementation of the Dialog.
 * The idea here is that for each query the parsed command line options are used instead.
 */
class CommandLineDialog : public Dialog
{
public:
  CommandLineDialog();
  virtual ~CommandLineDialog();

  virtual void queryEmpty(const char *, std::string = "");
  virtual void queryInt(const char *, std::string = "");
  virtual void queryInts(const char *, std::string = "");
  virtual void queryBoolean(const char *, std::string = "");
  virtual void queryString(const char*, std::string = "");
  virtual void queryStrings(const char*, std::string = "");
  virtual void queryDouble(const char*, std::string = "");
  virtual void queryDoubles(const char*, std::string = "");
  virtual void queryAtom(const char*, std::string = "");
  virtual void queryAtoms(const char*, std::string = "");
  virtual void queryMolecule(const char*, std::string = "");
  virtual void queryMolecules(const char*, std::string = "");
  virtual void queryVector(const char*, bool, std::string = "");
  virtual void queryVectors(const char*, bool, std::string = "");
  virtual void queryBox(const char*, std::string = "");
  virtual void queryElement(const char*, std::string = "");
  virtual void queryElements(const char*, std::string = "");

protected:
  // specialized stuff for text queries
  class EmptyCommandLineQuery : public Dialog::EmptyQuery {
  public:
    EmptyCommandLineQuery(std::string title, std::string _description = "");
    virtual ~EmptyCommandLineQuery();
    virtual bool handle();
  };

  class IntCommandLineQuery : public Dialog::IntQuery {
  public:
    IntCommandLineQuery(std::string title, std::string _description = "");
    virtual ~IntCommandLineQuery();
    virtual bool handle();
  };

  class IntsCommandLineQuery : public Dialog::IntsQuery {
  public:
    IntsCommandLineQuery(std::string title, std::string _description = "");
    virtual ~IntsCommandLineQuery();
    virtual bool handle();
  };

  class BooleanCommandLineQuery : public Dialog::BooleanQuery {
  public:
    BooleanCommandLineQuery(std::string title, std::string _description = "");
    virtual ~BooleanCommandLineQuery();
    virtual bool handle();
  };

  class DoubleCommandLineQuery : public Dialog::DoubleQuery {
  public:
    DoubleCommandLineQuery(std::string title, std::string _description = "");
    virtual ~DoubleCommandLineQuery();
    virtual bool handle();
  };

  class DoublesCommandLineQuery : public Dialog::DoublesQuery {
  public:
    DoublesCommandLineQuery(std::string title, std::string _description = "");
    virtual ~DoublesCommandLineQuery();
    virtual bool handle();
  };

  class StringCommandLineQuery : public Dialog::StringQuery {
  public:
    StringCommandLineQuery(std::string title, std::string _description = "");
    virtual ~StringCommandLineQuery();
    virtual bool handle();
  };

  class StringsCommandLineQuery : public Dialog::StringsQuery {
  public:
    StringsCommandLineQuery(std::string title, std::string _description = "");
    virtual ~StringsCommandLineQuery();
    virtual bool handle();
  };

  class AtomCommandLineQuery : public Dialog::AtomQuery {
  public:
    AtomCommandLineQuery(std::string title, std::string _description = "");
    virtual ~AtomCommandLineQuery();
    virtual bool handle();
  };

  class AtomsCommandLineQuery : public Dialog::AtomsQuery {
  public:
    AtomsCommandLineQuery(std::string title, std::string _description = "");
    virtual ~AtomsCommandLineQuery();
    virtual bool handle();
  };

  class MoleculeCommandLineQuery : public Dialog::MoleculeQuery {
  public:
    MoleculeCommandLineQuery(std::string title, std::string _description = "");
    virtual ~MoleculeCommandLineQuery();
    virtual bool handle();
  };

  class MoleculesCommandLineQuery : public Dialog::MoleculesQuery {
  public:
    MoleculesCommandLineQuery(std::string title, std::string _description = "");
    virtual ~MoleculesCommandLineQuery();
    virtual bool handle();
  };

  class VectorCommandLineQuery : public Dialog::VectorQuery {
  public:
    VectorCommandLineQuery(std::string title,bool _check, std::string _description = "");
    virtual ~VectorCommandLineQuery();
    virtual bool handle();
  };

  class VectorsCommandLineQuery : public Dialog::VectorsQuery {
  public:
    VectorsCommandLineQuery(std::string title,bool _check, std::string _description = "");
    virtual ~VectorsCommandLineQuery();
    virtual bool handle();
  };

  class BoxCommandLineQuery : public Dialog::BoxQuery {
  public:
    BoxCommandLineQuery(std::string title, std::string _description = "");
    virtual ~BoxCommandLineQuery();
    virtual bool handle();
  };

  class ElementCommandLineQuery : public Dialog::ElementQuery {
  public:
    ElementCommandLineQuery(std::string title, std::string _description = "");
    virtual ~ElementCommandLineQuery();
    virtual bool handle();
  };

  class ElementsCommandLineQuery : public Dialog::ElementsQuery {
  public:
    ElementsCommandLineQuery(std::string title, std::string _description = "");
    virtual ~ElementsCommandLineQuery();
    virtual bool handle();
  };
};

#endif /* COMMANDLINEDIALOG_HPP_ */
