/*
 * ObservedValue_wCallback.hpp
 *
 *  Created on: Oct 16, 2015
 *      Author: heber
 */


#ifndef OBSERVEDVALUE_WCALLBACK_HPP_
#define OBSERVEDVALUE_WCALLBACK_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/ObservedValue.hpp"
#include "CodePatterns/Observer/Observable.hpp"

/** We derive from ObservedValue in order to tell owning instance about
 * subjectKilled() having been called.
 */
template <class T>
class ObservedValue_wCallback : public ObservedValue<T>
{
public:
  ObservedValue_wCallback(
      const Observable * const _owner,
      const boost::function<T()> &_recalcMethod,
      const std::string &_name,
      const T &_initialvalue,
      const Observable::channels_t &_channels,
      const boost::function<void()> &_callback) :
        ObservedValue<T>(_owner, _recalcMethod, _name, _initialvalue, _channels),
        callback(_callback)
  {}
  virtual ~ObservedValue_wCallback()
  {}

protected:
  virtual void subjectKilled(Observable *publisher)
  {
    ObservedValue<T>::subjectKilled(publisher);
    callback();
  }

private:
  //!> callback function to tell other entity about subjectKilled
  const boost::function<void()> callback;
};

#endif /* OBSERVEDVALUE_WCALLBACK_HPP_ */
