/*
 * ManipulateAtomsProcess.hpp
 *
 *  Created on: Feb 18, 2010
 *      Author: crueger
 */

#ifndef MANIPULATEATOMSPROCESS_HPP_
#define MANIPULATEATOMSPROCESS_HPP_

#include "Actions/Process.hpp"
#include "Descriptors/AtomDescriptor.hpp"

class ManipulateAtomsProcess : public Process
{
public:
  ManipulateAtomsProcess(boost::function<void(atom*)> _operation, AtomDescriptor descr,std::string _name,bool _doRegister=true);
  virtual ~ManipulateAtomsProcess();

  virtual void call();
  virtual void undo();
  virtual bool canUndo();

  virtual void doManipulate(World *);
private:
  AtomDescriptor descr;
  boost::function<void(atom*)> operation;
};

#endif /* MANIPULATEATOMSPROCESS_HPP_ */
