/*
 * QtQueryList.hpp
 *
 *  Created on: Jul 24, 2012
 *      Author: ankele
 */

#ifndef QTQUERYLIST_HPP_
#define QTQUERYLIST_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Dialog.hpp"
#include "Parameters/Parameter.hpp"

class QListWidget;
class QPushButton;
class QVBoxLayout;
class QHBoxLayout;
class QBoxLayout;

class QtQueryListUntyped {
public:
  QtQueryListUntyped(QBoxLayout *parent, Dialog *_dialog);
  virtual ~QtQueryListUntyped(){}

  virtual void onSubUpdate() = 0;

  void onUpdate();
  void elementSelected();
  void addElementToListWidget(const std::string &str);
  std::vector<int> getSelectedRows();
  void removeSelectedRows(const std::vector<int> &rows);

protected:
  QListWidget *inputList;
  QPushButton *addButton;
  QPushButton *removeButton;
  QVBoxLayout *thisVLayout;
  QHBoxLayout *thisHLayout;
  QVBoxLayout *buttonBox;
  Dialog *dialog;
};

template<class T>
class QtQueryList : public QtQueryListUntyped {
public:
  QtQueryList(QBoxLayout *parent, Dialog *_dialog, std::vector<T> &_temp) : QtQueryListUntyped(parent, _dialog), tempRef(_temp)
  {
    subParam = new Parameter<T>("sub-param");
  }
  virtual ~QtQueryList()
  {
    delete(subParam);
  }

  void addElement() {
    // add item to both
    addElementToListWidget(subParam->getAsString());
    tempRef.push_back(subParam->get());
    onUpdate();
  }
  void removeElements()
  {
    std::vector<int> rows = getSelectedRows();
    removeSelectedRows(rows);
    for (int i = rows.size() - 1; i >= 0; i --){
      ASSERT(rows[i] < tempRef.size(), "QtQueryList<T>::removeElements() trying to remove invalid element.");
      tempRef.erase(tempRef.begin() + rows[i]);
    }
    onUpdate();
  }
protected:
  std::vector<T> &tempRef;
  Parameter<T> *subParam;
};



class ListQuerySubDialog : public Dialog
{
public:
  ListQuerySubDialog(QtQueryListUntyped *_parent) : parent(_parent), sub(NULL){}
  virtual void update()
  {
    if (sub)
      sub->handle();
    parent->onSubUpdate();
  }
  void setSubQuery(Query *_sub){  sub = _sub; }

  virtual void queryEmpty(const char*, std::string){}
  virtual void queryBoolean(Parameter<bool> &, const char *, std::string = ""){}
  virtual void queryInt(Parameter<int> &, const char *,std::string = ""){}
  virtual void queryInts(Parameter<std::vector<int> > &, const char *,std::string = ""){}
  virtual void queryUnsignedInt(Parameter<unsigned int> &, const char *,std::string = ""){}
  virtual void queryUnsignedInts(Parameter<std::vector<unsigned int> > &, const char *,std::string = ""){}
  virtual void queryDouble(Parameter<double> &, const char*,std::string = ""){}
  virtual void queryDoubles(Parameter<std::vector<double> > &, const char*,std::string = ""){}
  virtual void queryString(Parameter<std::string> &, const char*,std::string = ""){}
  virtual void queryStrings(Parameter<std::vector<std::string> > &, const char*,std::string = ""){}
  virtual void queryAtom(Parameter<const atom *> &, const char*,std::string = ""){}
  virtual void queryAtoms(Parameter<std::vector<const atom *> > &, const char*,std::string = ""){}
  virtual void queryMolecule(Parameter<const molecule *> &, const char*,std::string = ""){}
  virtual void queryMolecules(Parameter<std::vector<const molecule *> > &, const char*,std::string = ""){}
  virtual void queryVector(Parameter<Vector> &, const char*,std::string = ""){}
  virtual void queryVectors(Parameter<std::vector<Vector> > &, const char*,std::string = ""){}
  virtual void queryRealSpaceMatrix(Parameter<RealSpaceMatrix> &, const char*, std::string = ""){}
  virtual void queryElement(Parameter<const element *> &, const char*,std::string = ""){}
  virtual void queryElements(Parameter<std::vector<const element *> > &, const char*,std::string = ""){}
  virtual void queryFile(Parameter<boost::filesystem::path> &, const char*,std::string = ""){}
  virtual void queryFiles(Parameter<std::vector< boost::filesystem::path> > &, const char*,std::string = ""){}
  virtual void queryRandomNumberDistribution_Parameters(Parameter<RandomNumberDistribution_Parameters> &, const char*,std::string = ""){}
private:
  QtQueryListUntyped *parent;
  Query *sub;
};


#endif /* QTQUERYLIST_HPP_ */
