/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * QtQueryList.cpp
 *
 *  Created on: Jul 24, 2012
 *      Author: ankele
 */



// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qpushbutton.h>
#include <Qt/qlistwidget.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQueryList.hpp"


QtQueryListUntyped::QtQueryListUntyped(QBoxLayout *parent, Dialog *_dialog) :
  dialog(_dialog)
{
  thisVLayout = new QVBoxLayout();
  thisHLayout = new QHBoxLayout();
  buttonBox = new QVBoxLayout();
  inputList = new QListWidget();
  inputList->setSelectionMode(QAbstractItemView::ExtendedSelection);
  addButton = new QPushButton("Add");
  addButton->setEnabled(false);
  removeButton = new QPushButton("Remove");
  removeButton->setEnabled(false);

  buttonBox->addWidget(addButton);
  buttonBox->addWidget(removeButton);
  thisHLayout->addWidget(inputList);
  thisHLayout->addLayout(buttonBox);
  thisVLayout->addLayout(thisHLayout);
  parent->addLayout(thisVLayout);
}



void QtQueryListUntyped::onUpdate() {
  dialog->update();
}


void QtQueryListUntyped::elementSelected()
{
  removeButton->setEnabled(!inputList->selectedItems().empty());
}

void QtQueryListUntyped::addElementToListWidget(const std::string &str)
{
  inputList->addItem(QString(str.c_str()));
}


std::vector<int> QtQueryListUntyped::getSelectedRows()
{
  std::vector<int> rows;
  QList<QListWidgetItem*> items = inputList->selectedItems();
  for (QList<QListWidgetItem*>::iterator iter = items.begin(); !items.empty(); iter = items.begin()){
    rows.push_back(inputList->row(*iter));
    items.erase(iter);
  }
  return rows;
}

void QtQueryListUntyped::removeSelectedRows(const std::vector<int> &rows)
{
  for (int i = rows.size() - 1; i >= 0; i --)
    inputList->takeItem(rows[i]);
}
