/*
 * HomologyGraphUnitTest.hpp
 *
 *  Created on: Sep 25, 2012
 *      Author: heber
 */

#ifndef HOMOLOGYCONTAINERUNITTEST_HPP_
#define HOMOLOGYCONTAINERUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include "Fragmentation/Homology/FragmentEdge.hpp"
#include "Fragmentation/Homology/FragmentNode.hpp"

class HomologyGraph;

/********************************************** Test classes **************************************/

class HomologyGraphTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( HomologyGraphTest) ;
    CPPUNIT_TEST ( comparatorTest );
    CPPUNIT_TEST ( assigmentTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void comparatorTest();
      void assigmentTest();

private:
      HomologyGraph *graph;
      HomologyGraph::nodes_t nodes;
      HomologyGraph::edges_t edges;
      HomologyGraph::nodes_t othernodes;
      HomologyGraph::edges_t otheredges;
};

#endif /* HOMOLOGYCONTAINERUNITTEST_HPP_ */
