/*
 * VectorNotZeroValidator.hpp
 *
 *  Created on: Jul 10, 2012
 *      Author: ankele
 */

#ifndef VECTORNOTZEROVALIDATOR_HPP_
#define VECTORNOTZEROVALIDATOR_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "LinearAlgebra/Vector.hpp"

#include "Parameters/Validators/Validator.hpp"

/** This validator checks whether the given \ref Vector's components are
 * not all zero.
 */
class VectorNotZeroValidator : public Validator<Vector>
{
  bool isValid(const Vector & _value) const;
  bool operator==(const Validator<Vector> &_instance) const;
  Validator< Vector >* clone() const;
};



#endif /* VECTORNOTZEROVALIDATOR_HPP_ */
