/*
 * BoxUnittest.hpp
 *
 *  Created on: Jul 30, 2010
 *      Author: crueger
 */

#ifndef BOXUNITTEST_HPP_
#define BOXUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

class Matrix;
class Box;

class BoxUnittest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( BoxUnittest );
  CPPUNIT_TEST ( setBoxTest );
  CPPUNIT_TEST ( isInsideTest );
  CPPUNIT_TEST ( WrapExplodeTest );
  CPPUNIT_TEST ( BoundaryBounceTest );
  CPPUNIT_TEST ( BoundaryIgnoreTest );
  CPPUNIT_TEST ( BoundaryMixedTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void setBoxTest();
  void isInsideTest();
  void WrapExplodeTest();
  void BoundaryBounceTest();
  void BoundaryIgnoreTest();
  void BoundaryMixedTest();

  Matrix *unit;
  Matrix *zero;
  Matrix *invertible;
  Matrix *uninvertible;

  Box *unitBox;
  Box *stretchedBox1;
  Box *stretchedBox2;
  Box *stretchedBox3;
  Box *stretchedBox4;
  Box *tiltedBox1;
  Box *tiltedBox2;
  Box *tiltedBox3;
  Box *tiltedBox4;
};

#endif /* BOXUNITTEST_HPP_ */
