/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * atom_particleinfo.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "atom_particleinfo.hpp"

#include <iostream>

/** Constructor of ParticleInfo.
 */
ParticleInfo::ParticleInfo() :
  Nr(-1),
  name("Unknown")
{};

ParticleInfo::ParticleInfo(const ParticleInfo &pointer) :
  Nr(pointer.Nr),
  name(pointer.name)
{}


/** Destructor of ParticleInfo.
 */
ParticleInfo::~ParticleInfo()
{};

const string& ParticleInfo::getName() const{
  return name;
}

void ParticleInfo::setName(const string& _name){
  OBSERVE;
  NOTIFY(AtomObservable::NameChanged);
  name = _name;
}

ostream & operator << (ostream &ost, const ParticleInfo &a)
{
  ost << a.getName();
  return ost;
};

const int& ParticleInfo::getNr() const
{
  return Nr;
}

void ParticleInfo::setNr(const int newnr)
{
  Nr = newnr;
}

ostream & ParticleInfo::operator << (ostream &ost) const
{
  ost << getName();
  return ost;
};

