/** \file helpers.hpp
 *
 * Declaration of some auxiliary functions for memory dis-/allocation and so on
 */

#ifndef HELPERS_HPP_
#define HELPERS_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream>

#include "memoryallocator.hpp"

/********************************************** helpful functions *********************************/

// taken out of TREMOLO
/*@-namechecks@*/
#ifndef __GNUC__
# undef __attribute__
# define __attribute__(x)
#endif
/*@=namechecks@*/

/* Behandelt aufgetretene Fehler. error ist der Fehlertyp(enum Errors)
   void *SpecialData ist ein untypisierter Zeiger auf Spezielle Daten zur Fehlerbehandlung.
   Man koennte auch noch einen Zeiger auf eine Funktion uebergeben */
extern void /*@exits@*/ debug(const char *output);
  //__attribute__ ((__return__));
#define debug(data) debug_in((data), __FILE__, __LINE__)

extern void /*@exits@*/ debug_in(const char *output,
    const char *file, const int line);
  //__attribute__ ((__return__));

double ask_value(const char *text);
bool check_bounds(double *x, double *cell_size);
void bound(double *b, double lower_bound, double upper_bound);
int pot(int base, int n);
int CountLinesinFile(ifstream &InputFile);
char *FixedDigitNumber(const int FragmentNumber, const int digits);
bool IsValidNumber( const char *string);
int CompareDoubles (const void * a, const void * b);
double * ReturnFullMatrixforSymmetric(double *cell_size);
void performCriticalExit();

/********************************************** helpful template functions *********************************/

/** Flips two values.
 * \param x first value
 * \param y second value
 */
template <typename T> void flip(T &x, T &y)
{
  T tmp;
  tmp = x;
  x = y;
  y = tmp;
};

/** Creates a lookup table for true father's Atom::Nr -> atom ptr.
 * \param *out output stream for debugging
 * \param *start begin of chain list
 * \paran *end end of chain list
 * \param **Lookuptable pointer to return allocated lookup table (should be NULL on start)
 * \param count optional predetermined count for table (otherwise we set the count to highest true father id)
 * \return true - success, false - failure
 */
template <typename T> bool CreateFatherLookupTable(ofstream *out, T *start, T *end, T **&LookupTable, int count = 0)
{
  bool status = true;
  T *Walker = NULL;
  int AtomNo;

  if (LookupTable != NULL) {
    *out << "Pointer for Lookup table is not NULL! Aborting ..." <<endl;
    return false;
  }

  // count them
  if (count == 0) {
    Walker = start;
    while (Walker->next != end) { // create a lookup table (Atom::nr -> atom) used as a marker table lateron
      Walker = Walker->next;
      count = (count < Walker->GetTrueFather()->nr) ? Walker->GetTrueFather()->nr : count;
    }
  }
  if (count <= 0) {
    *out << "Count of lookup list is 0 or less." << endl;
    return false;
  }

  // allocate and fill
  LookupTable = Calloc<T*>(count, "CreateFatherLookupTable - **LookupTable");
  if (LookupTable == NULL) {
    cerr << "LookupTable memory allocation failed!" << endl;
    status = false;
  } else {
    for (int i=0;i<count;i++)
      LookupTable[i] = NULL;
    Walker = start;
    while (Walker->next != end) { // create a lookup table (Atom::nr -> atom) used as a marker table lateron
      Walker = Walker->next;
      AtomNo = Walker->GetTrueFather()->nr;
      if ((AtomNo >= 0) && (AtomNo < count)) {
        //*out << "Setting LookupTable[" << AtomNo << "] to " << *Walker << endl;
        LookupTable[AtomNo] = Walker;
      } else {
        *out << "Walker " << *Walker << " exceeded range of nuclear ids [0, " << count << ")." << endl;
        status = false;
        break;
      }
    }
  }

  return status;
};

/** Frees a two-dimensional array.
 * \param *ptr pointer to array
 * \param dim first dim of array
 */
template <typename X> void Free2DArray(X **ptr, int dim)
{
  int i;
  if (ptr != NULL) {
    for(i=dim;i--;)
      if (ptr[i] != NULL)
        free(ptr[i]);
    free(ptr);
  }
};

template <typename T> void Increment(T *value, T *inc)
{
  *value += *inc;
};

template <typename T> void AbsoluteValue(T *value, T *abs)
{
  *value = *abs;
};

template <typename T> void IncrementalAbsoluteValue(T *value, T *abs)
{
  *value = *abs;
  (*abs) += 1;
};



#endif /*HELPERS_HPP_*/
