/*
 * types.hpp
 *
 *  Created on: Nov 15, 2011
 *      Author: heber
 */

#ifndef LINKEDCELL_TYPES_HPP_
#define LINKEDCELL_TYPES_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <list>
#include <vector>

#include <boost/array.hpp>
#include <boost/multi_array.hpp>

#include "LinearAlgebra/defs.hpp"

class TesselPoint;

namespace LinkedCell {

  class LinkedCell;

  //!> three-dimensional array of LinkedCell instances
  typedef boost::multi_array<LinkedCell *, NDIM> LinkedCellArray;

  //!> vector of 3 indices
  typedef boost::array<LinkedCellArray::index, NDIM> tripleIndex;
}

#endif /* LINKEDCELL_TYPES_HPP_ */
