/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ObserverBoxStub.cpp
 *
 *  Created on: Dec 22, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Box.hpp"

#include "CodePatterns/Observer/Channels.hpp"
#include "CodePatterns/Observer/Notification.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"


Box::Box(RealSpaceMatrix _M) :
  Observable("Box"),
  M( new RealSpaceMatrix(_M) ),
  Minv( new RealSpaceMatrix )
{
  // observable stuff
  Channels *OurChannel = new Channels;
  NotificationChannels.insert( std::make_pair(this, OurChannel) );
  // add instance for each notification type
  OurChannel->addChannel(Box::MatrixChanged);
  *Minv = M->invert();
}

Box::~Box()
{
  // observable stuff
  std::map<Observable *, Channels*>::iterator iter = NotificationChannels.find(this);
  delete iter->second;
  NotificationChannels.erase(iter);

  delete M;
  delete Minv;
}

const RealSpaceMatrix &Box::getMinv() const
{
  return *Minv;
}

Vector Box::enforceBoundaryConditions(const Vector &point) const{
  return point;
}

const BoundaryConditions::Conditions_t & Box::getConditions() const
{
  return conditions.get();
}

double Box::periodicDistanceSquared(const Vector &point1,const Vector &point2) const
{
  return point1.DistanceSquared(point2);
}

void Box::setM(RealSpaceMatrix _M)
{
  OBSERVE;
  NOTIFY(MatrixChanged);
  delete M;
  M = new RealSpaceMatrix(_M);
  *Minv = M->invert();
}
