#ifndef ATOMDESCRIPTOR_IMPL_HPP
#define ATOMDESCRIPTOR_IMPL_HPP

#include "Descriptors/AtomDescriptor.hpp"

/************************ Declarations of implementation Objects ************************/

class AtomDescriptor_impl
{
  friend class AtomDescriptor;
public:

  AtomDescriptor_impl();
  virtual ~AtomDescriptor_impl();

  virtual bool predicate(std::pair<int,atom*>)=0;

protected:
  virtual atom* find();
  virtual std::vector<atom*> findAll();
  World::AtomSet& getAtoms();
};

/************************** Universe and Emptyset *****************/

class AtomAllDescriptor_impl : public AtomDescriptor_impl {
public:
  AtomAllDescriptor_impl();
  virtual ~AtomAllDescriptor_impl();
  virtual bool predicate(std::pair<int,atom*>);
};

class AtomNoneDescriptor_impl : public AtomDescriptor_impl {
public:
  AtomNoneDescriptor_impl();
  virtual ~AtomNoneDescriptor_impl();
  virtual bool predicate(std::pair<int,atom*>);
};

/************************** Operator stuff ************************/

class AtomAndDescriptor_impl : public AtomDescriptor_impl
{
public:
  AtomAndDescriptor_impl(AtomDescriptor::impl_ptr _lhs, AtomDescriptor::impl_ptr _rhs);
  ~AtomAndDescriptor_impl();
  virtual bool predicate(std::pair<int,atom*>);

private:
  AtomDescriptor::impl_ptr lhs;
  AtomDescriptor::impl_ptr rhs;
};

class AtomOrDescriptor_impl : public AtomDescriptor_impl
{
public:
  AtomOrDescriptor_impl(AtomDescriptor::impl_ptr _lhs, AtomDescriptor::impl_ptr _rhs);
  virtual ~AtomOrDescriptor_impl();
  virtual bool predicate(std::pair<int,atom*>);

private:
  AtomDescriptor::impl_ptr lhs;
  AtomDescriptor::impl_ptr rhs;
};

class AtomNotDescriptor_impl : public AtomDescriptor_impl
{
public:
  AtomNotDescriptor_impl(AtomDescriptor::impl_ptr _arg);
  virtual ~AtomNotDescriptor_impl();

  virtual bool predicate(std::pair<int,atom*>);

private:
  AtomDescriptor::impl_ptr arg;
};

#endif //ATOMDESCRIPTOR_IMPL_HPP
