/*
 * AtomIdDescriptor.cpp
 *
 *  Created on: Feb 5, 2010
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include "AtomIdDescriptor.hpp"
#include "AtomIdDescriptor_impl.hpp"

#include "atom.hpp"

using namespace std;


AtomIdDescriptor_impl::AtomIdDescriptor_impl(atomId_t _id) :
  id(_id)
{}

AtomIdDescriptor_impl::~AtomIdDescriptor_impl()
{}

bool AtomIdDescriptor_impl::predicate(std::pair<atomId_t,atom*> atom) {
  return atom.first==id;
}

AtomDescriptor AtomById(atomId_t id){
  return AtomDescriptor(AtomDescriptor::impl_ptr(new AtomIdDescriptor_impl(id)));
}

atom *AtomIdDescriptor_impl::find(){
  World::AtomSet atoms = getAtoms();
  World::AtomSet::iterator res = atoms.find(id);
  return (res!=atoms.end())?((*res).second):0;
}

vector<atom*> AtomIdDescriptor_impl::findAll(){
  atom *res = find();
  return (res)?(vector<atom*>(1,res)):(vector<atom*>());
}
