/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * QtUIFactory.cpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <cassert>

#include <qapplication.h>


#include "UIElements/Qt4/QtUIFactory.hpp"
#include "UIElements/Qt4/QtMainWindow.hpp"
#include "UIElements/Qt4/QtDialog.hpp"

#include "Helpers/MemDebug.hpp"

#include "version.h"
#include "Helpers/defs.hpp"

using namespace std;

QtUIFactory::QtUIFactory() :
  argc(1)
{
  // For now we just fake the command line parameters to make QT happy
  argv = new char*[1];
  argv[0] = new char[256];
  strcpy(argv[0],MOLECUILDERVERSION);
  app = new QApplication(argc,argv);
}

QtUIFactory::~QtUIFactory()
{
  delete app;
  delete [] argv[0];
  delete [] argv;
}

Dialog* QtUIFactory::makeDialog() {
  return new QtDialog();
}

MainWindow* QtUIFactory::makeMainWindow() {
  return new QtMainWindow(app);
}

QtUIFactory::description::description() :
    UIFactory::factoryDescription("Qt4")
{}

QtUIFactory::description::~description()
{}

UIFactory* QtUIFactory::description::makeFactory(){
  return new QtUIFactory();
}
