/*
 * VerboseAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/CmdAction/VerboseAction.hpp"
#include "CommandLineParser.hpp"
#include "log.hpp"
#include "verbose.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char CommandLineVerboseAction::NAME[] = "verbose";

CommandLineVerboseAction::CommandLineVerboseAction() :
  Action(NAME)
{}

CommandLineVerboseAction::~CommandLineVerboseAction()
{}

Action::state_ptr CommandLineVerboseAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  int verbosity = 2;

  dialog->queryInt(NAME, &verbosity, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    setVerbosity(verbosity);
    DoLog(0) && (Log() << Verbose(0) << "Setting verbosity to " << verbosity << "." << endl);
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr CommandLineVerboseAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr CommandLineVerboseAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool CommandLineVerboseAction::canUndo() {
  return false;
}

bool CommandLineVerboseAction::shouldUndo() {
  return false;
}

const string CommandLineVerboseAction::getName() {
  return NAME;
}
