/*
 * FastParsingAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/CmdAction/FastParsingAction.hpp"
#include "CommandLineParser.hpp"
#include "config.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char CommandLineFastParsingAction::NAME[] = "fastparsing";

CommandLineFastParsingAction::CommandLineFastParsingAction() :
  Action(NAME)
{}

CommandLineFastParsingAction::~CommandLineFastParsingAction()
{}

Action::state_ptr CommandLineFastParsingAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  config *configuration = World::getInstance().getConfig();
  dialog->queryBoolean(NAME, &configuration->FastParsing, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    if (configuration->FastParsing)
      DoLog(0) && (Log() << Verbose(0) << "I won't parse trajectories." << endl);
    else
      DoLog(0) && (Log() << Verbose(0) << "I will parse trajectories." << endl);
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr CommandLineFastParsingAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr CommandLineFastParsingAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool CommandLineFastParsingAction::canUndo() {
  return false;
}

bool CommandLineFastParsingAction::shouldUndo() {
  return false;
}

const string CommandLineFastParsingAction::getName() {
  return NAME;
}
