/*
 * BondLengthTableAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/CmdAction/BondLengthTableAction.hpp"
#include "CommandLineParser.hpp"
#include "config.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char CommandLineBondLengthTableAction::NAME[] = "bond-table";

CommandLineBondLengthTableAction::CommandLineBondLengthTableAction() :
  Action(NAME)
{}

CommandLineBondLengthTableAction::~CommandLineBondLengthTableAction()
{}

Action::state_ptr CommandLineBondLengthTableAction::performCall() {
  ostringstream usage;
  string BondGraphFileName;
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  config *configuration = World::getInstance().getConfig();
  dialog->queryString(NAME, &BondGraphFileName, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    delete dialog;
  } else {
    delete dialog;
  }

  if (configuration->BG == NULL) {
    configuration->BG = new BondGraph(configuration->GetIsAngstroem());
    if ((!BondGraphFileName.empty()) && (configuration->BG->LoadBondLengthTable(BondGraphFileName))) {
      DoLog(0) && (Log() << Verbose(0) << "Bond length table loaded successfully." << endl);
      return Action::success;
    } else {
      DoeLog(1) && (eLog()<< Verbose(1) << "Bond length table loading failed." << endl);
      return Action::failure;
    }
  } else {
    DoLog(0) && (Log() << Verbose(0) << "Bond length table already present." << endl);
    return Action::failure;
  }
}

Action::state_ptr CommandLineBondLengthTableAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr CommandLineBondLengthTableAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool CommandLineBondLengthTableAction::canUndo() {
  return false;
}

bool CommandLineBondLengthTableAction::shouldUndo() {
  return false;
}

const string CommandLineBondLengthTableAction::getName() {
  return NAME;
}
