/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeIdDescriptor.cpp
 *
 *  Created on: Feb 5, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "MoleculeIdDescriptor.hpp"
#include "MoleculeIdDescriptor_impl.hpp"

#include "Patterns/ObservedContainer_impl.hpp"

#include "molecule.hpp"

using namespace std;


MoleculeIdDescriptor_impl::MoleculeIdDescriptor_impl(moleculeId_t _id) :
  id(_id)
{}

MoleculeIdDescriptor_impl::~MoleculeIdDescriptor_impl()
{}

bool MoleculeIdDescriptor_impl::predicate(std::pair<moleculeId_t,molecule*> molecule) {
  return molecule.first==id;
}

MoleculeDescriptor MoleculeById(moleculeId_t id){
  return MoleculeDescriptor(MoleculeDescriptor::impl_ptr(new MoleculeIdDescriptor_impl(id)));
}

molecule *MoleculeIdDescriptor_impl::find(){
  World::MoleculeSet &molecules = getMolecules();
  World::MoleculeSet::iterator res = molecules.find(id);
  return (res!=molecules.end())?((*res).second):0;
}

vector<molecule*> MoleculeIdDescriptor_impl::findAll(){
  molecule *res = find();
  return (res)?(vector<molecule*>(1,res)):(vector<molecule*>());
}
