/*
 * QtObservedAtomObserver.hpp
 *
 *  Created on: Mar 16, 2016
 *      Author: heber
 */


#ifndef QTOBSERVEDATOMOBSERVER_HPP_
#define QTOBSERVEDATOMOBSERVER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QWidget>

#include "UIElements/Qt4/InstanceBoard/QtObservedAtom.hpp"
#include "types.hpp"

class QtObservedInstanceBoard;

/** This class serves all QtObservedAtom instances and relays specific
 * events, such as ElementChanged.
 *
 * This is to have single class that is informed about all changes of a
 * certain type, but on the Qt side, just as EntityObserver does on the
 * molecuilder side.
 *
 */
class QtObservedAtomObserver : public QWidget
{
  Q_OBJECT

public:
  QtObservedAtomObserver(QtObservedInstanceBoard *_board, QWidget * _parent = NULL);

signals:
  void ElementChanged(const QtObservedAtom::ptr _atom);

  // relayed signals
  void AtomInserted(const QtObservedAtom::ptr _atom);
  void AtomRemoved(const atomId_t _atomid);

private slots:
  // relayed, and modified signals
  void elementChanged();

  void atomInserted(const QtObservedAtom::ptr _atom);
  void atomRemoved(const atomId_t _atomid);

private:
  //!> ref to get objects from ids
  QtObservedInstanceBoard * const board;
};

#endif /* QTOBSERVEDATOMOBSERVER_HPP_ */
