/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2016 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * QtObservedAtomObserver.cpp
 *
 *  Created on: Mar 16, 2016
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "QtObservedAtomObserver.hpp"
#include "UIElements/Qt4/InstanceBoard/QtObservedInstanceBoard.hpp"

#include "CodePatterns/MemDebug.hpp"

QtObservedAtomObserver::QtObservedAtomObserver(
    QtObservedInstanceBoard *_board,
    QWidget * _parent) :
    QWidget(_parent),
    board(_board)
{
    connect(_board, SIGNAL(atomInserted(QtObservedAtom::ptr)),
        this, SLOT(atomInserted(QtObservedAtom::ptr)));
    connect(_board, SIGNAL(atomRemoved(const atomId_t)),
        this, SLOT(atomRemoved(const atomId_t)));
}

void QtObservedAtomObserver::elementChanged()
{
  QtObservedAtom * const walker = static_cast<QtObservedAtom *>(sender());
  emit ElementChanged(walker->getRef());
}

void QtObservedAtomObserver::atomInserted(const QtObservedAtom::ptr _atom)
{
  connect( _atom.get(), SIGNAL(elementChanged()), this, SLOT(elementChanged()));
  emit AtomInserted(_atom);
}

void QtObservedAtomObserver::atomRemoved(const atomId_t _atomid)
{
  const QtObservedAtom::ptr walker = board->getObservedAtom(_atomid);
  disconnect( walker.get(), SIGNAL(elementChanged()), this, SLOT(elementChanged()));
  emit AtomRemoved(_atomid);
}
