/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Registry<Action>.cpp
 *
 *  Created on: Jan 7, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/ActionRegistry.hpp"
#include "Patterns/Singleton_impl.hpp"
#include "Patterns/Registry_impl.hpp"

/** Constructor for class ActionRegistry.
 */
ActionRegistry::ActionRegistry()
{}

/** Destructor for class ActionRegistry.
 */
ActionRegistry::~ActionRegistry()
{
  cleanup();
}

/** Just passes on call to Registry<Action>::getByName().
 * \param name name of Action
 * \return pointer to Action
 */
Action* ActionRegistry::getActionByName(const std::string name)
{
  return getByName(name);
}

/** Just passes on call to Registry<Action>::isPresentByName().
 * \param name name of Action
 * \return true - Action instance present, false - not
 */
bool ActionRegistry::isActionPresentByName(const std::string name) const
{
  return isPresentByName(name);
}

/** Returns the last present action position in the requested menu.
 * \param &token token of the menu
 * \return last used position
 */
int ActionRegistry::getLastPosition(const std::string &token) const
{
  int position = 0;
  for (const_iterator iter = getBeginIter();
      iter != getEndIter();
      ++iter) {
    const std::string &MenuName = (iter->second)->Traits.getMenuName();
    const int &MenuPosition = (iter->second)->Traits.getMenuPosition();
    if ((MenuName == token) && (position < MenuPosition))
      position = MenuPosition;
  }
  return position;
}


CONSTRUCT_SINGLETON(ActionRegistry)
CONSTRUCT_REGISTRY(Action)
