/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * FragmentNodeUnitTest.cpp
 *
 *  Created on: Sep 24, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

// include headers that implement a archive in simple text format
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "Fragmentation/Homology/FragmentNode.hpp"
#include "Fragmentation/Graph.hpp"

#include "FragmentNodeUnitTest.hpp"

#include "CodePatterns/Assert.hpp"
#include <sstream>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( FragmentNodeTest );


void FragmentNodeTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);
}


void FragmentNodeTest::tearDown()
{
}

/** UnitTest for operator<(), operator>() and operator==()
 */
void FragmentNodeTest::comparatorTest()
{
  FragmentNode node(1,1);
  FragmentNode samenode(1,1);
  FragmentNode othernode(1,4);
  FragmentNode anothernode(2,2);
  FragmentNode yetanothernode(2,4);

  CPPUNIT_ASSERT( !(node < samenode) );
  CPPUNIT_ASSERT( node < othernode );
  CPPUNIT_ASSERT( node < anothernode );
  CPPUNIT_ASSERT( node < yetanothernode );
  CPPUNIT_ASSERT( othernode < anothernode );
  CPPUNIT_ASSERT( othernode < yetanothernode );
  CPPUNIT_ASSERT( anothernode < yetanothernode );

  CPPUNIT_ASSERT( !(node > samenode) );
  CPPUNIT_ASSERT( othernode > node );
  CPPUNIT_ASSERT( anothernode > node );
  CPPUNIT_ASSERT( anothernode > othernode );
  CPPUNIT_ASSERT( yetanothernode > node );
  CPPUNIT_ASSERT( yetanothernode > othernode );
  CPPUNIT_ASSERT( yetanothernode > anothernode );

  CPPUNIT_ASSERT( node == node );
  CPPUNIT_ASSERT( node == samenode );
  CPPUNIT_ASSERT( othernode == othernode );
  CPPUNIT_ASSERT( anothernode == anothernode );
  CPPUNIT_ASSERT( yetanothernode == yetanothernode );

  CPPUNIT_ASSERT( node != othernode );
  CPPUNIT_ASSERT( node != anothernode );
  CPPUNIT_ASSERT( node != yetanothernode );
  CPPUNIT_ASSERT( othernode != anothernode );
  CPPUNIT_ASSERT( othernode != yetanothernode );
  CPPUNIT_ASSERT( anothernode != yetanothernode );
}

/** UnitTest for operator=()
 */
void FragmentNodeTest::assignmentTest()
{
  FragmentNode node(1,1);
  FragmentNode samenode(1,1);
  FragmentNode othernode(1,4);

  // check initial status
  CPPUNIT_ASSERT( node == samenode);
  CPPUNIT_ASSERT( node != othernode);

  // now assign
  samenode = othernode;
  othernode = node;

  // and check again
  CPPUNIT_ASSERT( node != samenode);
  CPPUNIT_ASSERT( node == othernode);

  // also self-assign
  node = node;
  CPPUNIT_ASSERT( node == node);
}


/** UnitTest for serialization
 */
void FragmentNodeTest::serializeTest()
{
  FragmentNode node(1,1);
  // serialize
  std::stringstream outputstream;
  boost::archive::text_oarchive oa(outputstream);
  oa << node;

  // deserialize
  FragmentNode samenode;
  std::stringstream returnstream(outputstream.str());
  boost::archive::text_iarchive ia(returnstream);
  ia >> samenode;

  CPPUNIT_ASSERT( node == samenode );
}
