/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the COPYING file or "Copyright notice" in builder.cpp for details.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>. 
 */

/*
 * HomologyGraph_getFromKeyset.cpp
 *
 *  Created on: Sep 25, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Fragmentation/Homology/HomologyGraph.hpp"

#include "CodePatterns/Log.hpp"

#include "Atom/atom.hpp"
#include "Bond/bond.hpp"
#include "Descriptors/AtomIdDescriptor.hpp"
#include "Fragmentation/KeySet.hpp"
#include "World.hpp"

// we have placed these functions into an extra module to allow compiling the
// unit tests which do no require them against dummy units which do not pull
// in all the cludder of World, atom, molecule, and so on ...

namespace detail {
  const HomologyGraph::nodes_t getNodesFromKeySet(const KeySet &keyset)
  {
    HomologyGraph::nodes_t nodes;
    for (KeySet::const_iterator iter = keyset.begin();
        iter != keyset.end(); ++iter) {
      const atom *Walker = World::getInstance().getAtom(AtomById(*iter));
      if (Walker != NULL) {
        const BondList& ListOfBonds = Walker->getListOfBonds();
  #ifndef NDEBUG
      std::pair<HomologyGraph::nodes_t::iterator,bool> inserter =
  #endif
          nodes.insert( FragmentNode(Walker->getElementNo(), ListOfBonds.size()) );
      } else {
        ELOG(0, "Id " << *iter << " is not associated with any atom.");
      }
    }
    return nodes;
  }

  const HomologyGraph::edges_t getEdgesFromKeySet(const KeySet &keyset)
  {
    HomologyGraph::edges_t edges;
    for (KeySet::const_iterator iter = keyset.begin();
        iter != keyset.end(); ++iter) {
      const atom *Walker = World::getInstance().getAtom(AtomById(*iter));
      if (Walker != NULL) {
        const BondList& ListOfBonds = Walker->getListOfBonds();
        for (BondList::const_iterator bonditer = ListOfBonds.begin();
            bonditer != ListOfBonds.begin(); ++iter) {
          const atom *OtherWalker = (*bonditer)->GetOtherAtom(Walker);
          if (Walker->getId() < OtherWalker->getId())
            edges.insert( FragmentEdge( Walker->getElementNo(), OtherWalker->getElementNo()) );
        }
      } else {
        ELOG(0, "Id " << *iter << " is not associated with any atom.");
      }
    }
    return edges;
  }
};  /* namespace detail */

