/*
 * FragmentEdge.hpp
 *
 *  Created on: Sep 24, 2012
 *      Author: heber
 */

#ifndef FRAGMENTEDGE_HPP_
#define FRAGMENTEDGE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/serialization/export.hpp>
#include <boost/serialization/utility.hpp>

#include <iosfwd>
#include <utility>

class FragmentEdge
{
  //!> grant output operator access to internals
  friend std::ostream& operator<<(std::ostream &out, const FragmentEdge &node);
public:
  typedef std::pair<size_t, size_t> AtomicNumberPair_t;

  FragmentEdge();
  FragmentEdge(const AtomicNumberPair_t &_pair);
  FragmentEdge(const size_t _left, const size_t _right);
  ~FragmentEdge()
  {}

  FragmentEdge& operator=(const FragmentEdge &edge);

  bool operator<(const FragmentEdge &edge) const;
  bool operator>(const FragmentEdge &edge) const;
  bool operator==(const FragmentEdge &edge) const;
  bool operator!=(const FragmentEdge &edge) const {
    return (!(*this == edge));
  }

private:
  //!> stores the atomic number of either FragmentNode making up the edge
  const AtomicNumberPair_t AtomicNumberPair;

private:
  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & const_cast<AtomicNumberPair_t &>(AtomicNumberPair);
  }
};

// we need to give this class a unique key for serialization
BOOST_CLASS_EXPORT_KEY(FragmentEdge)

std::ostream& operator<<(std::ostream &out, const FragmentEdge &node);

#endif /* FRAGMENTEDGE_HPP_ */
