/*
 * ManipulateAtomsProcess.cpp
 *
 *  Created on: Feb 18, 2010
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include "ManipulateAtomsProcess.hpp"

#include <iostream>

#include "World.hpp"
#include "Helpers/Assert.hpp"

using namespace std;

ManipulateAtomsProcess::ManipulateAtomsProcess(boost::function<void(atom*)> _operation, AtomDescriptor _descr,
                                               std::string _name,bool _doRegister) :
  Process(0,_name,_doRegister),
  descr(_descr),
  operation(_operation)
{}

ManipulateAtomsProcess::~ManipulateAtomsProcess()
{}

Dialog* ManipulateAtomsProcess::createDialog(){
  return NULL;
}

Action::state_ptr ManipulateAtomsProcess::performCall(){
  World::getInstance().doManipulate(this);
  return Action::success;
}

Action::state_ptr ManipulateAtomsProcess::performUndo(Action::state_ptr){
  ASSERT(0,"Undo called for a ManipulateAtomsProcess");
  return Action::success;
}

Action::state_ptr ManipulateAtomsProcess::performRedo(Action::state_ptr){
  ASSERT(0,"Redo called for a ManipulateAtomsProcess");
  return Action::success;
}

bool ManipulateAtomsProcess::canUndo(){
  return false;
}

bool ManipulateAtomsProcess::shouldUndo(){
  return true;
}

void ManipulateAtomsProcess::doManipulate(World *world){
  setMaxSteps(world->numAtoms());
  start();
  for(World::internal_AtomIterator
      iter=world->getAtomIter_internal(descr);
      iter!=world->atomEnd_internal();
      ++iter){

    setCurrStep(iter.getCount());
    operation(*iter);
  }
  stop();
}
