/*
 * errorLogger.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: metzler
 */

#ifndef ERRORLOGGER_HPP_
#define ERRORLOGGER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>

#include "CodePatterns/Singleton.hpp"

using namespace std;

class Verbose;

class errorLogger : public Singleton<errorLogger>{
  friend class Singleton<errorLogger>;
public :
  static ostream *nix;
  static ostream *out;
  static ostream *defaultout;
  static int verbosity;

  static bool DoOutput();
  static void setVerbosity(int verbosityLevel);
  static int getVerbosity();
  static void setOutputStream(ostream *_newout);

protected:
  /** Do not call this constructor directly, use getInstance() instead. */
  errorLogger();
  /** Do not call this destructor directly, use purgeInstance() instead. */
  ~errorLogger();

};

ostream& operator<<(class errorLogger&l, const Verbose& ost);
ostream& operator<<(class errorLogger*l, const Verbose& ost);

#endif /* ERRORLOGGER_HPP_ */
