/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ActionRegistryUnitTest.cpp
 *
 *  Created on: Dec 15, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "ActionRegistryUnitTest.hpp"

#include <typeinfo>

#include "Actions/ActionQueue.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Actions/ActionTrait.hpp"
#include "Actions/OptionRegistry.hpp"
#include "Actions/OptionTrait.hpp"

using namespace MoleCuilder;

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ActionRegistryTest );


void ActionRegistryTest::setUp()
{
  AR = &ActionQueue::getInstance().getActionRegistry();
};


void ActionRegistryTest::tearDown()
{
  ActionQueue::purgeInstance();
};

void ActionRegistryTest::CheckDoublyUsedShortforms()
{
  std::map <std::string, std::string> result;

  for (ActionRegistry::const_iterator iter = AR->getBeginIter(); iter != AR->getEndIter(); ++iter) {
    if ((iter->second)->Traits.hasShortForm()) {
      ASSERT(result.find((iter->second)->Traits.getShortForm()) == result.end(),
          "Short form "+toString((iter->second)->Traits.getShortForm())+
          " for action "+toString(iter->first)+" already present from "+
          std::string(result[(iter->second)->Traits.getShortForm()])+"!");
      result[(iter->second)->Traits.getShortForm()] = (iter->second)->getName();
    }
  }
}
