/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

 /** \file builder.cpp
 *
 *  date: Jan 1, 2007
 *  author: heber
 *
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "builder_init.hpp"
#include "cleanUp.hpp"
#include "UIElements/UIFactory.hpp"

/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  initGeneral();

  initUI(argc,argv);

  doUI();

  if (UIFactory::getInstance().getUIName() == "CommandLine")
    return saveAll();
  return 0;
}

/********************************************** E N D **************************************************/
