/*
 * LinearInterpolationofTrajectoriesAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/LinearInterpolationofTrajectoriesAction.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

#include "atom.hpp"
#include "defs.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

/****** MoleculeLinearInterpolationofTrajectoriesAction *****/

// memento to remember the state when undoing

//class MoleculeLinearInterpolationofTrajectoriesState : public ActionState {
//public:
//  MoleculeLinearInterpolationofTrajectoriesState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeLinearInterpolationofTrajectoriesAction::NAME[] = "linear-interpolate";

MoleculeLinearInterpolationofTrajectoriesAction::MoleculeLinearInterpolationofTrajectoriesAction() :
  Action(NAME)
{}

MoleculeLinearInterpolationofTrajectoriesAction::~MoleculeLinearInterpolationofTrajectoriesAction()
{}

Dialog* MoleculeLinearInterpolationofTrajectoriesAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryString(NAME, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryInt("start-step", MapOfActions::getInstance().getDescription("start-step"));
  dialog->queryInt("end-step", MapOfActions::getInstance().getDescription("end-step"));
  dialog->queryBoolean("id-mapping", MapOfActions::getInstance().getDescription("id-mapping"));

  return dialog;
}

Action::state_ptr MoleculeLinearInterpolationofTrajectoriesAction::performCall() {
  string filename;
  molecule *mol = NULL;
  int start = -1;
  int end = -1;
  bool IdMapping = true;

  ValueStorage::getInstance().queryCurrentValue(NAME, filename);
  ValueStorage::getInstance().queryCurrentValue("start-step", start);
  ValueStorage::getInstance().queryCurrentValue("end-step", end);
  ValueStorage::getInstance().queryCurrentValue("id-mapping", IdMapping);

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(1) && (Log() << Verbose(1) << "Linear interpolation between configuration " << start << " and " << end << "." << endl);
    if (IdMapping)
      DoLog(1) && (Log() << Verbose(1) << "Using Identity for the permutation map." << endl);
    if (!mol->LinearInterpolationBetweenConfiguration(start, end, filename, *(World::getInstance().getConfig()), IdMapping))
      DoLog(2) && (Log() << Verbose(2) << "Could not store " << filename << " files." << endl);
    else
      DoLog(2) && (Log() << Verbose(2) << "Steps created and " << filename << " files stored." << endl);
  }
  return Action::success;
}

Action::state_ptr MoleculeLinearInterpolationofTrajectoriesAction::performUndo(Action::state_ptr _state) {
//  MoleculeLinearInterpolationofTrajectoriesState *state = assert_cast<MoleculeLinearInterpolationofTrajectoriesState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeLinearInterpolationofTrajectoriesAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeLinearInterpolationofTrajectoriesAction::canUndo() {
  return false;
}

bool MoleculeLinearInterpolationofTrajectoriesAction::shouldUndo() {
  return false;
}

const string MoleculeLinearInterpolationofTrajectoriesAction::getName() {
  return NAME;
}
