/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementDbAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "config.hpp"
#include "element.hpp"    // we need element because of serialization!
#include "periodentafel.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <string>

#include "Actions/CommandAction/ElementDbAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "ElementDbAction.def"
#include "Actions/Action_impl_pre.hpp"

/** =========== define the function ====================== */
Action::state_ptr CommandElementDbAction::performCall() {
  std::ostringstream usage;

  // obtain information
  getParametersfromValueStorage();
  periodentafel *&periode = World::getInstance().getPeriode();

  // create undo state
  std::stringstream undostream;
  boost::archive::text_oarchive oa(undostream);
  oa << periode;
  CommandElementDbState *UndoState =
      new CommandElementDbState(
          undostream.str(),
          params
          );

  // get the path
  // TODO: Make databasepath a std::string
  config *configuration = World::getInstance().getConfig();
  strcpy(configuration->databasepath, params.databasepath.branch_path().string().c_str());

  // load table
  periode->CleanupPeriodtable();
  if (periode->LoadPeriodentafel(configuration->databasepath)) {
    DoLog(0) && (Log() << Verbose(0) << "Element list loaded successfully." << endl);
    //periode->Output();
    return Action::state_ptr(UndoState);
  } else {
    DoLog(0) && (Log() << Verbose(0) << "Element list loading failed." << endl);
    delete UndoState;
    return Action::failure;
  }
}

Action::state_ptr CommandElementDbAction::performUndo(Action::state_ptr _state) {
  CommandElementDbState *state = assert_cast<CommandElementDbState*>(_state.get());

  periodentafel *periode;

  std::stringstream undostream(state->undostring);
  boost::archive::text_iarchive ia(undostream);
  ia >> periode;

  delete World::getInstance().getPeriode();
  World::getInstance().getPeriode() = periode;

  return Action::state_ptr(_state);
}

Action::state_ptr CommandElementDbAction::performRedo(Action::state_ptr _state){
  CommandElementDbState *state = assert_cast<CommandElementDbState*>(_state.get());

  // get the path
  // TODO: Make databasepath a std::string
  config *configuration = World::getInstance().getConfig();
  strcpy(configuration->databasepath, state->params.databasepath.branch_path().string().c_str());

  // load table
  periodentafel *&periode = World::getInstance().getPeriode();
  periode->CleanupPeriodtable();
  if (periode->LoadPeriodentafel(configuration->databasepath)) {
    DoLog(0) && (Log() << Verbose(0) << "Element list loaded successfully." << endl);
    //periode->Output();
    return Action::state_ptr(_state);
  } else {
    DoLog(0) && (Log() << Verbose(0) << "Element list loading failed." << endl);
    return Action::failure;
  }
}

bool CommandElementDbAction::canUndo() {
  return true;
}

bool CommandElementDbAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
