/*
 * DepthFirstSearchAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Actions/FragmentationAction/DepthFirstSearchAction.hpp"
#include "atom.hpp"
#include "config.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "stackclass.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char FragmentationDepthFirstSearchAction::NAME[] = "depth-first-search";

FragmentationDepthFirstSearchAction::FragmentationDepthFirstSearchAction() :
  Action(NAME)
{}

FragmentationDepthFirstSearchAction::~FragmentationDepthFirstSearchAction()
{}

Action::state_ptr FragmentationDepthFirstSearchAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  double distance;

  dialog->queryDouble(NAME, &distance, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    DoLog(1) && (Log() << Verbose(1) << "Depth-First-Search Analysis." << endl);
    molecule * const mol = World::getInstance().getMolecule(MoleculeById(0));
    MoleculeLeafClass *Subgraphs = NULL;      // list of subgraphs from DFS analysis
    int *MinimumRingSize = new int[mol->getAtomCount()];
    atom ***ListOfLocalAtoms = NULL;
    class StackClass<bond *> *BackEdgeStack = NULL;
    class StackClass<bond *> *LocalBackEdgeStack = NULL;
    mol->CreateAdjacencyList(distance, World::getInstance().getConfig()->GetIsAngstroem(), &BondGraph::CovalentMinMaxDistance, NULL);
    Subgraphs = mol->DepthFirstSearchAnalysis(BackEdgeStack);
    if (Subgraphs != NULL) {
      int FragmentCounter = 0;
      while (Subgraphs->next != NULL) {
        Subgraphs = Subgraphs->next;
        Subgraphs->FillBondStructureFromReference(mol, FragmentCounter, ListOfLocalAtoms, false);  // we want to keep the created ListOfLocalAtoms
        LocalBackEdgeStack = new StackClass<bond *> (Subgraphs->Leaf->BondCount);
        Subgraphs->Leaf->PickLocalBackEdges(ListOfLocalAtoms[FragmentCounter], BackEdgeStack, LocalBackEdgeStack);
        Subgraphs->Leaf->CyclicStructureAnalysis(LocalBackEdgeStack, MinimumRingSize);
        delete(LocalBackEdgeStack);
        delete(Subgraphs->previous);
        FragmentCounter++;
      }
      delete(Subgraphs);
      for (int i=0;i<FragmentCounter;i++)
        delete[](ListOfLocalAtoms[i]);
      delete[](ListOfLocalAtoms);
    }
    delete(BackEdgeStack);
    delete[](MinimumRingSize);
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr FragmentationDepthFirstSearchAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr FragmentationDepthFirstSearchAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool FragmentationDepthFirstSearchAction::canUndo() {
  return false;
}

bool FragmentationDepthFirstSearchAction::shouldUndo() {
  return false;
}

const string FragmentationDepthFirstSearchAction::getName() {
  return NAME;
}
